/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// PlayingMarble.glsl
// original code from https://www.shadertoy.com/view/MtX3Ws
// simplified edit: Robert 25.11.2015
// see also https://www.shadertoy.com/view/Mlj3zWprecision mediump float;
// modified color calculation by I.G.P.

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;
// uniform vec2 mouse;
// uniform vec2 resolution;
// uniform vec2 surfacesize;

vec3 roty(vec3 p,float a)
{ return p*mat3(cos(a),0,-sin(a),0,1,0,sin(a),0,cos(a)); }

float map(in vec3 p) 
{
	float res=0.;vec3 c = p;
	for (int i = 0; i < 4; i++) 
	{
		p =0.9*abs(p)/dot(p,p) -.7;
		p.yz= vec2(p.y*p.y-p.z*p.z,2.*p.y*p.z);
		res += exp(-20. * abs(dot(p,c)));
	}
	return res/2.0;
}

vec3 raymarch(vec3 ro, vec3 rd)
{
	float t = 4.0;
	vec3 col=vec3(0);float c=0.;
	for( int i=0; i<64; i++ )
	{
		t += 0.02*exp(-2.0*c);
		c = map(ro+t*rd);               
		col = 0.98*col + 0.08*vec3(c*c, c, c*c*c);  //green	
		col = 0.98*col + 0.08*vec3(c*c*c, c*c, c);  //blue
		col = 0.98*col + 0.08*vec3(c, c*c*c, c*c);  //red

	}
	return col;
}

void main()
{
    vec2 p = (scaled_gl_FragCoord.xy-resolution/2.0)/(resolution.y);
    vec3 ro = roty(vec3(3.),time*0.3+mouse.x);
    vec3 uu = normalize( cross(ro,vec3(0.0, 1.0, 0.0) ) );
    vec3 vv = normalize( cross(uu,ro));
    vec3 rd = normalize( p.x*uu + p.y*vv -ro*0.3 );
    gl_FragColor.rgb = 0.5*log(1.0+raymarch(ro,rd));
    gl_FragColor.a = length(gl_FragColor.rgb);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}
